<?php

if (!defined('ABSPATH')) {
    exit;
}

define( 'MY_PLUGIN_VERSION', '1.0.0' );
define( 'MY_PLUGIN_FILE', __FILE__ );


function LoadDPGateway()
{

    if (!function_exists('addDPGatewayToWC') && class_exists('WC_Payment_Gateway') && !class_exists('WCDigiPay')) {

        function addDPGatewayToWC($methods)
        {
            $methods[] = 'WCDigiPay';
            return $methods;
        }
        function addDpCurrenciesToWC($currencies)
        {
            $currencies['IRR'] = __('ریال', 'woocommerce');
            $currencies['IRT'] = __('تومان', 'woocommerce');

            return $currencies;
        }
        function addDpCurrenciesSymbolsToWC($currency_symbol, $currency)
        {
            switch ($currency) {
                case 'IRR':
                    $currency_symbol = 'ریال';
                    break;
                case 'IRT':
                    $currency_symbol = 'تومان';
                    break;
            }
            return $currency_symbol;
        }

        add_filter('woocommerce_payment_gateways',          'addDPGatewayToWC');
        add_filter('woocommerce_currencies',                'addDpCurrenciesToWC');
        add_filter('woocommerce_currency_symbol',           'addDpCurrenciesSymbolsToWC', 10, 2);

        require_once ("WCDigiPay.php");
    }
}

add_action('plugins_loaded', 'LoadDPGateway', 0);