<?php
defined('ABSPATH') || exit;

add_filter('pre_set_site_transient_update_plugins', 'wc_dp_check_for_update_production');

function wc_dp_check_for_update_production($transient)
{
    if (empty($transient->checked)) return $transient;

    $remote = get_transient('wc_dp_update_info');

    if (false === $remote) {
        $response = wp_remote_get(WC_DP_UPDATE_API, [
            'timeout' => 10,
            'user-agent' => 'WC-DigiPay/' . WC_DP_VERSION . '; ' . home_url()
        ]);

        if (is_wp_error($response)) return $transient;
        if (wp_remote_retrieve_response_code($response) !== 200) return $transient;

        $remote = json_decode(wp_remote_retrieve_body($response));
        if (empty($remote) || empty($remote->version) || empty($remote->download_url)) return $transient;

        set_transient('wc_dp_update_info', $remote, 6 * HOUR_IN_SECONDS);
    }

    if (version_compare(WC_DP_VERSION, $remote->version, '>=')) return $transient;

    $update = new stdClass();
    $update->slug = 'wc-digipay-plugin';
    $update->plugin = WC_DP_PLUGIN_BASENAME;
    $update->new_version = $remote->version;
    $update->package = $remote->download_url;
    $update->tested = $remote->tested ?? '';
    $update->requires = $remote->requires ?? '';

    $transient->response[WC_DP_PLUGIN_BASENAME] = $update;

    return $transient;
}

add_filter('plugins_api', 'wc_dp_plugin_information_production', 20, 3);
function wc_dp_plugin_information_production($result, $action, $args)
{
    if ($action !== 'plugin_information' || empty($args->slug) || $args->slug !== 'wc-digipay-plugin') return $result;

    $remote = get_transient('wc_dp_update_info');
    if (!$remote) return $result;

    return (object)[
        'name' => 'درگاه پرداخت دیجی‌پی برای ووکامرس',
        'slug' => 'wc-digipay-plugin',
        'version' => $remote->version,
        'author' => '<a href="https://www.mydigipay.com/">Digipay</a>',
        'homepage' => 'https://www.mydigipay.com/',
        'requires' => $remote->requires ?? '',
        'tested' => $remote->tested ?? '',
        'sections' => [
            'description' => 'درگاه رسمی دیجی‌پی برای ووکامرس',
            'changelog' => $remote->changelog ?? '<p>تغییری ثبت نشده است.</p>'
        ]
    ];
}

add_action('admin_notices', 'wc_dp_update_admin_notice_production');
function wc_dp_update_admin_notice_production()
{
    if (!current_user_can('update_plugins')) return;

    $remote = get_transient('wc_dp_update_info');
    if (!$remote || empty($remote->version)) return;
    if (version_compare(WC_DP_VERSION, $remote->version, '>=')) return;

    echo '<div class="notice notice-info is-dismissible">';
    echo '<p>🔔 <strong>درگاه پرداخت دیجی‌پی</strong>: نسخه جدید <strong>' . esc_html($remote->version) . '</strong> منتشر شده است. ';
    echo '<a href="' . esc_url(admin_url('plugins.php')) . '">برای بروزرسانی کلیک کنید</a></p>';
    echo '</div>';
}
