<?php

if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists("DPGateway")) {
    include_once "DPGateway.php";
}
if (!class_exists("Utilities")) {
    include_once "Utilities.php";
}

class WCDigiPay extends WC_Payment_Gateway
{
    private $failedMassage;
    private $successMassage;

    public function __construct()
    {
        $this->id = 'WCDigiPay';
        $this->method_title = __('درگاه هوشمند دیجی‌پی', 'woocommerce');
        $this->method_description = __('تنظیمات درگاه پرداخت هوشمند دیجی‌پی برای ووکامرس', 'woocommerce');
        $this->icon = apply_filters('WCDigiPay_Logo', WP_PLUGIN_URL . '/' . plugin_basename(__DIR__) . '/logo.png');
        $this->has_fields = false;
        $this->supports = ['refunds'];

        $this->init_form_fields();
        $this->init_settings();

        $this->title = __('درگاه هوشمند دیجی‌پی', 'woocommerce');
        $this->description = $this->settings['description'];

        $this->successMassage = $this->settings['success_massage'];
        $this->failedMassage = $this->settings['failed_massage'];

        if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=')) {
            add_action('woocommerce_update_options_payment_gateways_' . $this->id,
                array($this, 'process_admin_options'));
        } else {
            add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));
        }

        add_action('woocommerce_receipt_' . $this->id . '', array($this, 'digiPayPaymentRequest'));
        add_action('woocommerce_api_' . strtolower(get_class($this)) . '', array($this, 'digiPayPaymentCallback'), 1000);
        add_action('woocommerce_process_shop_order_meta', array($this, 'digipayUpdateCustomOrderFields'), 1000);
        add_action('add_meta_boxes', array($this, 'digipayAddCustomBox'));
        add_action('add_meta_boxes_shop_order', array($this, 'digipayAddCustomBox'));
        add_action('admin_head', array($this, 'digipayPreAddCustomBox'), 1);


    }

    public function process_refund($order_id, $amount = null, $reason = '')
    {

        $order = wc_get_order($order_id);
        $trackingCode = get_post_meta($order_id, 'dp_tracking_code', true);
        $type = get_post_meta($order_id, 'dp_type', true);
        if (empty($trackingCode)) {
            $trackingCode = get_post_meta($order_id, '_dp_tracking_code', true);
        }
        if (!isset($type) || $type === '') {
            $type = get_post_meta($order_id, '_dp_type', true);
        }

        if (empty($trackingCode) || (!isset($type) || $type === '')) {
            return new WP_Error(400, "داده های دیتابیس ناقص است، لطفا با پشتیبانی دیجی‌پی تماس بگیرید.");
        }

        if (empty($amount) || $amount > $order->order_total) {
            return new WP_Error(400, "مبلغ ریفاند از مبلغ باقیمانده سفارش بیشتر است");
        }

        $currency = $order->get_currency();

        try {
            $amount = (int)$this->convertToIRR($amount, $currency);

        } catch (Exception $e) {
            return new WP_Error(400, $e->getMessage());
        }

        try {
            $dp = $this->digipayInit();
            $refundCode = $dp->refund($amount, $order->get_id() . "___" . rand(1, 1000), $trackingCode, $type, $reason);
            if ($refundCode) {
                $order->add_order_note(sprintf(__('ریفاند توسط دیجی‌پی انجام شد .<br/> کد رهگیری : %s<br/>مبلغ : %s',
                    'woocommerce'), $refundCode, $amount), 1);
                return true;
            } else {
                return new WP_Error(400, 'خطای ناشناخته ای رخ داده است');
            }
        } catch (\Throwable $e) {
            return new WP_Error(400, $e->getMessage());
        }
    }

    public function process_admin_options()
    {
        if (isset($_POST['woocommerce_WCDigiPay_enabled'])) {
            $this->init_settings();
            $this->settings['access_token'] = null;
            $this->settings['refresh_token'] = null;

            update_option(WC_Settings_API::get_option_key(), $this->settings, 'yes');
        }

        return parent::process_admin_options();
    }

    public function init_form_fields()
    {
        $this->form_fields = apply_filters('WCDigiPay_Config',
            [
                'enabled' => [
                    'title' => __('وضعیت درگاه', 'woocommerce'),
                    'type' => 'checkbox',
                    'label' => __('فعالسازی درگاه دیجی‌پی', 'woocommerce'),
                    'description' => __('برای فعالسازی درگاه انتخاب کنید', 'woocommerce'),
                    'default' => 'yes',
                    'desc_tip' => true,
                ],
                'description' => [
                    'title' => __('توضیحات پرداخت', 'woocommerce'),
                    'type' => 'text',
                    'desc_tip' => true,
                    'description' => __('توضیحاتی که در طی عملیات پرداخت از طریق درگاه دیجی‌پی نمایش داده خواهد شد',
                        'woocommerce'),
                    'default' => __('پرداخت هوشمند از طریق درگاه دیجی‌پی به وسیله کلیه کارت های عضو شبکه شتاب',
                        'woocommerce')
                ],
                'username' => [
                    'title' => __('نام کاربری', 'woocommerce'),
                    'type' => 'text',
                    'description' => __('نام کاربری دریافتی از دیجی‌پی', 'woocommerce'),
                    'default' => '',
                    'desc_tip' => true
                ],
                'password' => [
                    'title' => __('رمزعبور', 'woocommerce'),
                    'type' => 'text',
                    'description' => __('رمز عبور دریافتی از دیجی‌پی', 'woocommerce'),
                    'default' => '',
                    'desc_tip' => true
                ],
                'client_id' => [
                    'title' => __('Client ID', 'woocommerce'),
                    'type' => 'text',
                    'description' => __('Client ID دریافتی از دیجی‌پی', 'woocommerce'),
                    'default' => '',
                    'desc_tip' => true
                ],
                'client_secret' => [
                    'title' => __('Client Secret', 'woocommerce'),
                    'type' => 'text',
                    'description' => __('Client Secret دریافتی از دیجی‌پی', 'woocommerce'),
                    'default' => '',
                    'desc_tip' => true
                ],
                'success_massage' => [
                    'title' => __('پیام پرداخت موفق', 'woocommerce'),
                    'type' => 'textarea',
                    'description' => __('متن پیامی که میخواهید بعد از پرداخت موفق به کاربر نمایش دهید را وارد نمایید . همچنین می توانید از کد {ref_code} برای نمایش کد رهگیری دیجی‌پی استفاده نمایید .',
                        'woocommerce'),
                    'default' => __('با تشکر از شما . سفارش شما با موفقیت پرداخت شد .', 'woocommerce'),
                ],
                'failed_massage' => [
                    'title' => __('پیام پرداخت ناموفق', 'woocommerce'),
                    'type' => 'textarea',
                    'description' => __('متن پیامی که میخواهید بعد از پرداخت ناموفق به کاربر نمایش دهید را وارد نمایید . همچنین می توانید از شورت کد {error} برای نمایش دلیل خطای رخ داده استفاده نمایید . این دلیل خطا از دیجی‌پی ارسال میگردد .',
                        'woocommerce'),
                    'default' => __('پرداخت شما ناموفق بوده است . لطفا مجددا تلاش نمایید.', 'woocommerce'),
                ]
            ]
        );
    }

    public function process_payment($order_id)
    {
        $order = new WC_Order($order_id);
        return [
            'result' => 'success',
            'redirect' => $order->get_checkout_payment_url(true)
        ];
    }

    public function convertToIRR($amount, $currency)
    {
        switch ($currency) {
            case 'IRHR' :
                return $amount * 1000;

            case 'IRHT' :
                return $amount * 10000;

            case 'IRR'  :
                return $amount;

            case 'IRT'  :
                return $amount * 10;

            default :
                throw new Exception("این ارز در دیجی‌پی پشتیبانی نمیشود");

        }
    }

    public function digiPayPaymentRequest($order_id)
    {
        global $woocommerce;

        echo '<form action="" method="POST" class="dp-checkout" id="dp-checkout"><input type="submit" name="dp_submit" class="button alt" id="dp-payment-button" value="' . __('پرداخت',
                'woocommerce') . '"/><a class="button cancel" href="' . wc_get_checkout_url() . '">' . __('بازگشت',
                'woocommerce') . '</a></form><br/>';


        $woocommerce->session->dp_order_id = $order_id;

        $order = new WC_Order($order_id);
        $currency = $order->get_currency();

        try {
            $amount = (int)$this->convertToIRR($order->order_total, $currency);

        } catch (Exception $e) {
            wc_add_notice($e->getMessage(), 'error');
            exit;
        }

        $callbackUrl = add_query_arg('wc_order', $order_id, WC()->api_request_url('WCDigiPay'));
        $mobile = $order->get_billing_phone();
        $resID = (int)$order->get_order_number();
        $dp = $this->digipayInit();
        if (empty($mobile)) {
            $message = 'برای استفاده از درگاه پرداخت دیجی‌پی ثبت شماره تماس خریدار الزامیست';
            echo $message;
            return;
        } else {
            $mobile = Utilities::mobileNumberStandardizer($mobile);
            if (!$mobile) {
                $message = 'شماره تماس خریدار معتبر نیست';
                echo $message;
                return;
            }
        }

        $cartContent = $woocommerce->cart->get_cart_contents();
        $items = [];

        foreach ($cartContent as $content) {
            $items[] = [
                'sellerId' => 1,
                'supplierId' => 1,
                'productCode' => $content['data']->get_sku() ?? $content['product_id'],
                'brand' => '',
                'productType' => 1,
                'count' => $content['quantity'],
                'categoryId' => $content['data']->get_category_ids()[0] ?? '0'
            ];
        }

        try {

            $result = $dp->createTicket($amount, $resID, $callbackUrl, $items, $mobile);
            return wp_redirect($result);

        } catch (Exception $e) {

            echo $e->getMessage();
            $message = ' تراکنش ناموفق بود - خطا : ' . $e->getMessage();

            $message = sprintf(__('خطا در هنگام ارسال به بانک : %s', 'woocommerce'), $message);

            $order->add_order_note($message);
            wc_add_notice($message, 'error');
        }

    }

    public function digiPayPaymentCallback()
    {
        global $woocommerce;

        if (isset($_GET['wc_order'])) {
            $order_id = $_GET['wc_order'];
        } else {
            $order_id = $woocommerce->session->dp_order_id;
            unset($woocommerce->session->dp_order_id);
        }

        if ($order_id) {

            $order = new WC_Order($order_id);

            $result = $_POST['result'];
            $amount = $_POST['amount'];
//            $providerId = $_POST['providerId'];
            $trackingCode = $_POST['trackingCode'];
            $type = !empty($_POST['type']) ? $_POST['type'] : '0';

            if ($order->status !== 'completed') {

                if ($result === 'SUCCESS') {

                    $currency = $order->get_currency();
                    $orderAmount = (int)$this->convertToIRR($order->order_total, $currency);
                    $dp = $this->digipayInit();

                    try {

                        if ($amount != $orderAmount) {
                            wc_add_notice("مبلغ پرداختی با سفارش مطابقت ندارد", 'error');
                            return wp_redirect(wc_get_checkout_url());
                        }

                        try {
                            $result = $dp->verifyTicket($trackingCode, $order_id, $type);
                            if ($result === true) {
                                $result = update_post_meta($order_id, '_transaction_id', $trackingCode);
                                if (!$result) {
                                    update_post_meta($order_id, '_transaction_id', $trackingCode);
                                }
                                $result2 = update_post_meta($order_id, '_dp_tracking_code', $trackingCode);
                                if(!$result2) {
                                    update_post_meta($order_id, '_dp_tracking_code', $trackingCode);
                                }
                                $result3 = update_post_meta($order_id, '_dp_type', $type);
                                if(!$result3) {
                                    update_post_meta($order_id, '_dp_type', $type);
                                }
                                $order->payment_complete($trackingCode);
                                $woocommerce->cart->empty_cart();

                                $order->add_order_note(sprintf(__('پرداخت موفقیت آمیز بود .<br/> کد رهگیری : %s',
                                    'woocommerce'), $trackingCode), 1);

                                $msg = str_replace('{transaction_id}', $trackingCode,
                                    wpautop(wptexturize($this->successMassage)));

                                if ($msg) {
                                    wc_add_notice($msg, 'success');
                                }
                                wp_redirect(add_query_arg('wc_status', 'success', $this->get_return_url($order)));
                            } else {
                                $msg = str_replace(array('{transaction_id}', '{fault}'),
                                    array($trackingCode, 'خطا در تایید تراکنش'),
                                    wpautop(wptexturize($this->failedMassage)));
                                if ($msg) {
                                    wc_add_notice($msg, 'error');
                                }
                                return wp_redirect(wc_get_checkout_url());
                            }
                        } catch (\Throwable $e) {
                            $msg = str_replace(array('{transaction_id}', '{fault}'),
                                array($trackingCode, $e->getMessage()), wpautop(wptexturize($this->failedMassage)));

                            if ($msg) {
                                wc_add_notice($msg, 'error');
                            }

                            return wp_redirect(wc_get_checkout_url());
                        }
                    } catch (Exception $e) {


                        $msg = str_replace(array('{transaction_id}', '{fault}'), array($trackingCode, $e->getMessage()),
                            wpautop(wptexturize($this->failedMassage)));

                        if ($msg) {
                            wc_add_notice($msg, 'error');
                        }

                        return wp_redirect(wc_get_checkout_url());

                    }
                } else {


                    $msg = str_replace(array('{transaction_id}', '{fault}'), array($trackingCode, "تراکنش ناموفق بود"),
                        wpautop(wptexturize($this->failedMassage)));

                    if ($msg) {
                        wc_add_notice($msg, 'error');
                    }

                    return wp_redirect(wc_get_checkout_url());
                }

            }

            $msg = str_replace('{transaction_id}', get_post_meta($order_id, '_transaction_id', true),
                wpautop(wptexturize($this->successMassage)));

            if ($msg) {
                wc_add_notice($msg, 'success');
            }

            return wp_redirect(add_query_arg('wc_status', 'success', $this->get_return_url($order)));
        }

        $msg = str_replace('{fault}', __('شماره سفارش وجود ندارد .', 'woocommerce'),
            wpautop(wptexturize($this->failedMassage)));

        if ($msg) {
            wc_add_notice($msg, 'error');
        }

        return wp_redirect(wc_get_checkout_url());
    }

    private function digipayInit()
    {
        $this->init_settings();

        $hook = function ($accessToken, $refreshToken) {

            $this->settings['access_token'] = $accessToken;
            $this->settings['refresh_token'] = $refreshToken;

            update_option(WC_Settings_API::get_option_key(), $this->settings, 'yes');
            return true;
        };

        return new DPGateway($this->settings, $hook);
    }

    public function digipayHandleCustomOrderFields($post)
    {
        $id = null;
        if (!$post instanceof WP_Post) {
            try {
                $id = $post->get_id();
            } catch (\Throwable $e) {
                $id = $post->ID;
            }
        } else {
            $id = $post->ID;
        }
        if (!empty($id)) {
            $trackingCode = get_post_meta($id, 'dp_tracking_code', true);
            $type = get_post_meta($id, 'dp_type', true);
            if (empty($trackingCode)) {
                $trackingCode = get_post_meta($id, '_dp_tracking_code', true);
            }
        }
        if (!isset($type) || $type == '') {
            $type = get_post_meta($id, '_dp_type', true);
        }
        ?>
        <div class="form-field form-field-wide">
            <label for="_dp_tracking_code">کد رهگیری تراکنش</label>
            <input type="text" id="_dp_tracking_code" name="_dp_tracking_code" value="<?php echo $trackingCode; ?>">
        </div>
        <div class="form-field form-field-wide">
            <label for="_dp_type">نوع</label>
            <select style="display: block; width: 100%" id="_dp_type" name="_dp_type">
                <option value="" <?php echo $type === null ? 'selected' : '' ?>>نامشخص</option>
                <option value="0" <?php echo $type == '0' ? 'selected' : '' ?>>IPG</option>
                <option value="11" <?php echo $type == '11' ? 'selected' : '' ?>>WALLET</option>
                <option value="5" <?php echo $type == '5' ? 'selected' : '' ?>>CREDIT</option>
                <option value="13" <?php echo $type == '13' ? 'selected' : '' ?>>BNPL</option>
                <option value="24" <?php echo $type == '24' ? 'selected' : '' ?>>CREDIT-CARD</option>
            </select>
        </div>
        <?php
        wp_nonce_field('save_custom_order_meta_box', 'custom_order_meta_box_nonce');
    }

    public function digipayUpdateCustomOrderFields($order_id)
    {
        if (isset($_POST['_dp_tracking_code'])) {
            $trackingCode = $_POST['_dp_tracking_code'];
            delete_post_meta($order_id, '_dp_tracking_code');
            delete_post_meta($order_id, '_transaction_id');
            update_post_meta($order_id, '_dp_tracking_code', $trackingCode);
            update_post_meta($order_id, '_transaction_id', $trackingCode);
        }
        if (isset($_POST['_dp_type'])) {
            $type = $_POST['_dp_type'];
            delete_post_meta($order_id, '_dp_type');
            update_post_meta($order_id, '_dp_type', $type);
        }
    }

    public function digipayPreAddCustomBox()
    {
        $is_custom_orders_page = isset($_GET['page'], $_GET['action']) && $_GET['page'] === 'wc-orders' && $_GET['action'] === 'edit';
        if ($is_custom_orders_page) {
            $this->digipayAddCustomBox();
        }
    }

    public function digipayAddCustomBox()
    {
        $current_screen = get_current_screen();
        $is_custom_orders_page = isset($_GET['page'], $_GET['action']) && $_GET['page'] === 'wc-orders' && $_GET['action'] === 'edit';
        $screen = $is_custom_orders_page
            ? $current_screen->id // Use the current screen ID for custom orders
            : (wc_get_container()->get(Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController::class)->custom_orders_table_usage_is_enabled()
                ? wc_get_page_screen_id('shop-order')
                : 'shop_order');
        add_meta_box(
            'dp_meta_box',                  // Meta box ID
            'داده های درگاه پرداخت دیجی‌پی', // Meta box title
            array($this, 'digipayHandleCustomOrderFields'),         // Callback function
            $screen,                            // Post type (shop_order for WooCommerce orders)
            'side',                                  // Context ('side', 'normal', or 'advanced')
            'high'                                // Priority ('default', 'low', 'high')
        );
    }
}
