<?php
/**
 * author: Amir Adabi
 * date: 10/08/2024
 */

class Utilities
{

    public static function mobileNumberStandardizer($number)
    {
        $number = preg_replace('/\D/', '', $number);

        if (preg_match('/^(098|98|0098|\+98)/', $number)) {
            $number = preg_replace('/^(98|0098|\+98)/', '', $number);
        }

        if (preg_match('/^9\d{9}$/', $number)) {
            $number = '0' . $number;
        }

        if (preg_match('/^09\d{9}$/', $number)) {
            return $number;
        } else {
            return false;
        }
    }

    public static function convertNumbers($srting,$toPersian)
    {
        $en_num = array('0','1','2','3','4','5','6','7','8','9');
        $fa_num = array('۰','۱','۲','۳','۴','۵','۶','۷','۸','۹');
        if( $toPersian ) return str_replace($en_num, $fa_num, $srting);
        else return str_replace($fa_num, $en_num, $srting);
    }


}